<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Proyek;
use App\Models\Pengeluaran;
use App\Models\Tagihan;
use App\Models\Tukang;

class DashboardController extends Controller
{
    /**
     * Menampilkan dashboard untuk owner.
     */
    public function index()
    {
        // Logika Laporan Keuangan
        $totalPemasukan = Proyek::sum('nilai_kontrak');
        
        $pengeluaranDariSupplier = Pengeluaran::sum('total');
        $pengeluaranDariTagihan = Tagihan::where('status_bayar', 'Sudah Dibayar')->sum('nilai_tagihan');
        $pengeluaranDariUpahTukang = Tukang::sum('jumlah');

        // PERBAIKAN DI SINI:
        // Nama variabel diubah menjadi 'totalPengeluaran' agar cocok dengan view.
        $totalPengeluaran = $pengeluaranDariSupplier + $pengeluaranDariTagihan + $pengeluaranDariUpahTukang;

        $profitLoss = $totalPemasukan - $totalPengeluaran;

        // Mengirim variabel yang namanya sudah benar ke view.
        return view('layouts.owner.dashboard', compact('totalPemasukan', 'totalPengeluaran', 'profitLoss'));
    }
}

