<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        // [DIUBAH] Tambahkan 'proyeks.tukangs' untuk mengambil data pembayaran tukang
        $user = Auth::user()->load('proyeks.pengeluarans', 'proyeks.tukangs');

        $proyekList = $user->proyeks;

        // --- Kalkulasi Ulang Berdasarkan Proyek yang Sudah Difilter ---
        
        // [DIUBAH] Hitung total pengeluaran dari material DAN tukang
        $totalPengeluaranMaterial = $proyekList->flatMap(function ($proyek) {
            return $proyek->pengeluarans;
        })->sum('total');
        
        $totalPengeluaranTukang = $proyekList->flatMap(function ($proyek) {
            return $proyek->tukangs;
        })->sum('total_pembayaran');

        $totalPemasukan = $proyekList->sum('nilai_kontrak');
        $totalPengeluaran = $totalPengeluaranMaterial + $totalPengeluaranTukang; // Total biaya gabungan
        $profitLoss = $totalPemasukan - $totalPengeluaran;

        // --- Data Laporan per Proyek ---
        $laporanProyek = $proyekList->map(function ($proyek) {
            
            // [DIUBAH] Hitung total biaya gabungan untuk setiap proyek
            $total_pengeluaran_proyek = $proyek->pengeluarans->sum('total');
            $total_tukang_proyek = $proyek->tukangs->sum('total_pembayaran');
            $total_biaya_proyek = $total_pengeluaran_proyek + $total_tukang_proyek;
            
            $profit_loss_proyek = $proyek->nilai_kontrak - $total_biaya_proyek;

            return (object) [
                'id_proyek' => $proyek->id_proyek,
                'nama_proyek' => $proyek->nama_proyek,
                'status' => $proyek->status,
                'nilai_kontrak' => $proyek->nilai_kontrak,
                'klien' => $proyek->klien, // [DITAMBAHKAN] Kirim nama klien
                
                // [DIUBAH] Kirim total biaya gabungan
                'total_pengeluaran' => $total_biaya_proyek, 
                'profit_loss' => $profit_loss_proyek,
                
                // [DITAMBAHKAN] Kirim data list untuk modal popup
                'pengeluarans' => $proyek->pengeluarans, 
                'tukangs' => $proyek->tukangs,
                
                // [DITAMBAHKAN] Kirim total individual untuk stat card modal
                'total_material_only' => $total_pengeluaran_proyek,
                'total_tukang_only' => $total_tukang_proyek,
            ];
        });

        // --- Data untuk Grafik Pie ---
        $pieChartData = [
            'labels' => ['Pemasukan', 'Pengeluaran'],
            'values' => [$totalPemasukan, $totalPengeluaran], // Ini sudah benar (menggunakan total gabungan)
        ];

        // --- Data untuk Diagram Batang ---
        $barChartLabels = $laporanProyek->pluck('nama_proyek');
        $barChartValues = $laporanProyek->pluck('profit_loss'); // Ini sudah benar (menggunakan profit/loss gabungan)
        
        $barChartColors = $barChartValues->map(fn($value) => $value >= 0 ? 'rgba(59, 130, 246, 0.6)' : 'rgba(249, 115, 22, 0.6)');
        $barChartBorderColors = $barChartValues->map(fn($value) => $value >= 0 ? 'rgba(59, 130, 246, 1)' : 'rgba(249, 115, 22, 1)');

        $barChartData = [
            'labels' => $barChartLabels,
            'datasets' => [
                [
                    'label' => 'Profit/Loss per Proyek',
                    'data' => $barChartValues,
                    'backgroundColor' => $barChartColors,
                    'borderColor' => $barChartBorderColors,
                    'borderWidth' => 1
                ]
            ]
        ];
        
        return view('layouts.Owner.dashboard', compact(
            'totalPemasukan', 
            'totalPengeluaran', 
            'profitLoss',
            'pieChartData',
            'laporanProyek',
            'barChartData'
        ));
    }
}