<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DataKlien;
// Model 'Setting' sudah TIDAK diperlukan lagi

class ProgressKlienController extends Controller
{
    /**
     * [DIPERBARUI]
     * Menampilkan halaman Kanban.
     * Logika 'settings' dan 'documentList' dihapus.
     */
    public function index()
    {
        // 1. Tentukan kolom-kolom Kanban
        $kolomStatus = ['Belum Lengkap', 'Proses', 'Lengkap'];

        // 2. Ambil semua data klien, di-grup berdasarkan status
        $klienGrouped = DataKlien::with('proyek', 'user')
            ->get()
            ->groupBy('status');

        // 3. Siapkan data untuk view
        $kolomTugas = [];
        foreach ($kolomStatus as $status) {
            $kolomTugas[] = (object) [
                'nama' => $status,
                'tasks' => $klienGrouped->get($status, collect())
            ];
        }

        // 4. Kirim data ke view (hanya kolomTugas)
        return view('progress.index', compact('kolomTugas'));
    }

    /**
     * [FUNGSI BARU/PENGGANTI]
     * Menyimpan seluruh array checklist dari satu kartu klien.
     */
    public function saveChecklist(Request $request)
    {
        $request->validate([
            'klien_id' => 'required|exists:data_kliens,id',
            'checklist' => 'nullable|array' // Menerima seluruh array checklist
        ]);

        $klien = DataKlien::find($request->klien_id);

        // Langsung simpan seluruh array yang dikirim dari Alpine.js
        $klien->checklist_status = $request->checklist;
        
        $klien->save();

        return response()->json([
            'success' => true,
            'message' => 'Checklist disimpan.'
        ]);
    }
}