<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Anggota extends Model
{
    use HasFactory;

    /**
     * Tentukan nama tabel jika tidak mengikuti standar laravel (opsional)
     * Tapi 'Anggota' -> 'anggota' sudah standar.
     */
    protected $table = 'anggota';

    /**
     * Kolom yang boleh diisi secara massal.
     * Sesuaikan dengan kolom di tabel 'anggota' Anda.
     */
    protected $fillable = [
        'nama',
        'posisi',
        'no_hp',
    ];

    /**
     * Relasi: Satu Anggota bisa memiliki banyak Task.
     */
    public function tasks()
    {
        return $this->hasMany(Task::class, 'anggota_id');
    }
}