<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DataKlien extends Model
{
    use HasFactory;

    /**
     * Tentukan nama tabel jika berbeda dari default (data_kliens)
     * * @var string
     */
    protected $table = 'data_kliens'; // Ini sudah benar

    /**
     * Atribut yang dapat diisi secara massal (mass assignable).
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id_proyek',
        'id_user',
        'alamat',
        'jenis_bangunan',
        'nomor_pbg',
        'tanggal_terbit',
        'status_arsitek',
        'tanggal_oss',
        'Analisa',
        'keterangan',
        'status',
        'ktp',
        'shm',
        'gambar', 
        'ITR',
        'perhitungan_MEP',
        'checklist_status', // <-- [PERBAIKAN 1] TAMBAHKAN INI
    ];

    /**
     * Atribut yang harus di-cast ke tipe data tertentu.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'gambar' => 'array', 
        'tanggal_terbit' => 'date',
        'tanggal_oss' => 'date',
        'checklist_status' => 'array', // <-- [PERBAIKAN 2] TAMBAHKAN INI
    ];

    /**
     * Relasi ke model Proyek.
     */
    public function proyek()
    {
        return $this->belongsTo(Proyek::class, 'id_proyek', 'id_proyek');
    }

    /**
     * Relasi ke model User (Klien).
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'id_user', 'id');
    }
}