@extends('layouts.app')

@section('content')

@php
/**
 * Helper function untuk mem-parsing tanggal dengan aman di dalam view.
 * Mencegah error InvalidFormatException.
 */
function safeParseDateForInput($dateString) {
    if (empty($dateString)) {
        return '';
    }
    if (is_numeric($dateString)) {
        return '';
    }
    try {
        return \Carbon\Carbon::parse($dateString)->format('Y-m-d');
    } catch (\Exception $e) {
        return '';
    }
}

// [BARU] Definisikan class input yang bersih untuk digunakan berulang kali
$inputStyle = "w-full p-2 border border-transparent rounded-md text-sm hover:border-gray-300 focus:border-blue-500 focus:ring-1 focus:ring-blue-500 focus:bg-white transition duration-150";
@endphp

<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Review dan Penyesuaian Data</h1>
        @if($proyek)
            <p class="text-gray-500 mt-1">
                Data untuk proyek: <strong class="text-blue-600">{{ $proyek->nama_proyek }}</strong>
            </p>
        @endif
        <p class="text-gray-500 mt-1">
            Silakan periksa data di bawah ini. Anda dapat melakukan penyesuaian sebelum menyimpan.
        </p>
    </div>

    <form action="{{ route('inputdata.process') }}" method="POST">
        @csrf
        <input type="hidden" name="id_proyek" value="{{ $idProyek }}">

        {{-- =============================================== --}}
        {{-- FORM 1: DATA PENGELUARAN --}}
        {{-- =============================================== --}}
        @if (!empty($pengeluaranData))
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 mb-8">
            <div class="p-6 border-b border-gray-200">
                <h2 class="text-xl font-semibold text-gray-800">Review Data Pengeluaran</h2>
                <p class="text-sm text-gray-500 mt-1">Ditemukan {{ count($pengeluaranData) }} data pengeluaran untuk diimpor.</p>
            </div>
            
            <div class="overflow-x-auto">
                {{-- Padding di wrapper tabel untuk ruang nafas --}}
                <div class="p-4 sm:p-6">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[150px]">Toko</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[200px]">Items</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[140px]">Total</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[150px]">Tgl. Struk</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[140px]">Status Bayar</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[150px]">Tgl. Bayar</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach ($pengeluaranData as $index => $row)
                                <tr class="hover:bg-gray-50 transition duration-150">
                                    {{-- [DIUBAH] Gunakan $inputStyle --}}
                                    <td class="px-2 py-1"><input type="text" name="rows_pengeluaran[{{ $index }}][toko]" value="{{ $row['toko'] ?? '' }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1"><input type="text" name="rows_pengeluaran[{{ $index }}][items]" value="{{ $row['items'] ?? '' }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1"><input type="number" step="0.01" name="rows_pengeluaran[{{ $index }}][total]" value="{{ $row['total'] ?? '' }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1"><input type="date" name="rows_pengeluaran[{{ $index }}][tanggal_struk]" value="{{ safeParseDateForInput($row['tanggal_struk'] ?? null) }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1">
                                        <select name="rows_pengeluaran[{{ $index }}][status_bayar]" class="{{ $inputStyle }}">
                                            <option value="sudah bayar" @if(strtolower($row['status_bayar'] ?? '') == 'sudah bayar') selected @endif>Sudah Bayar</option>
                                            <option value="belum bayar" @if(strtolower($row['status_bayar'] ?? '') == 'belum bayar') selected @endif>Belum Bayar</option>
                                        </select>
                                    </td>
                                    <td class="px-2 py-1"><input type="date" name="rows_pengeluaran[{{ $index }}][tanggal_bayar]" value="{{ safeParseDateForInput($row['tanggal_bayar'] ?? null) }}" class="{{ $inputStyle }}"></td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif


        {{-- =============================================== --}}
        {{-- FORM 2: DATA TUKANG --}}
        {{-- =============================================== --}}
        @if (!empty($tukangData))
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 mb-8">
            <div class="p-6 border-b border-gray-200">
                <h2 class="text-xl font-semibold text-gray-800">Review Data Upah Tukang</h2>
                <p class="text-sm text-gray-500 mt-1">Ditemukan {{ count($tukangData) }} data tukang untuk diimpor.</p>
            </div>
            
            <div class="overflow-x-auto">
                <div class="p-4 sm:p-6">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[160px]">Nama Tukang</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[160px]">Nama Mandor</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[140px]">Jumlah</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[150px]">Jatuh Tempo</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider min-w-[140px]">Status</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach ($tukangData as $index => $row)
                                <tr class="hover:bg-gray-50 transition duration-150">
                                    {{-- [DIUBAH] Gunakan $inputStyle --}}
                                    <td class="px-2 py-1"><input type="text" name="rows_tukang[{{ $index }}][nama_tukang]" value="{{ $row['nama_tukang'] ?? '' }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1"><input type="text" name="rows_tukang[{{ $index }}][nama_mandor]" value="{{ $row['nama_mandor'] ?? '' }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1"><input type="number" step="0.01" name="rows_tukang[{{ $index }}][jumlah]" value="{{ $row['jumlah'] ?? '' }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1"><input type="date" name="rows_tukang[{{ $index }}][jatuh_tempo]" value="{{ safeParseDateForInput($row['jatuh_tempo'] ?? null) }}" class="{{ $inputStyle }}"></td>
                                    <td class="px-2 py-1">
                                        <select name="rows_tukang[{{ $index }}][status]" class="{{ $inputStyle }}">
                                            <option value="Belum Lunas" @if(strtolower($row['status'] ?? '') == 'belum lunas') selected @endif>Belum Lunas</option>
                                            <option value="Lunas" @if(strtolower($row['status'] ?? '') == 'lunas') selected @endif>Lunas</option>
                                        </select>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif

        {{-- Tombol Aksi (Dengan Ikon) --}}
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-6 sticky bottom-4 z-10">
            <div class="flex justify-end gap-4">
                <a href="{{ route('inputdata.index') }}" 
                   class="inline-flex items-center gap-2 bg-gray-200 text-gray-800 font-bold py-3 px-6 rounded-lg hover:bg-gray-300 transition duration-300 text-base">
                   <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm.707-10.293a1 1 0 00-1.414-1.414L7 8.586V7a1 1 0 00-2 0v4a1 1 0 001 1h4a1 1 0 000-2H8.586l2.293-2.293z" clip-rule="evenodd" /></svg>
                   Batal
                </a>
                <button type="submit" 
                        class="w-auto inline-flex items-center gap-2 bg-green-600 text-white font-bold py-3 px-6 rounded-lg hover:bg-green-700 transition duration-300 text-base">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" /></svg>
                    Simpan Penyesuaian
                </button>
            </div>
        </div>
    </form>
</div>
@endsection