@extends('layouts.app')

@section('content')
<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Buat Proyek Baru</h1>
        <p class="text-gray-500 mt-1">Isi detail di bawah untuk menambahkan proyek baru ke dalam sistem.</p>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-gray-200">
        @if ($errors->any())
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 text-red-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Oops! Ada beberapa kesalahan:</p>
                <ul class="mt-2 list-disc list-inside text-sm">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('proyek.store') }}" method="POST" class="space-y-6">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                {{-- Kolom Kiri --}}
                <div class="space-y-4">
                    <div>
                        <label for="nama_proyek" class="block text-sm font-medium text-gray-700 mb-1">Nama Proyek</label>
                        <input type="text" name="nama_proyek" id="nama_proyek" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('nama_proyek') }}" required>
                    </div>

                    {{-- [DIUBAH] Input Klien disamakan seperti 'tukang' --}}
                    <div>
                        <label for="klien" class="block text-sm font-medium text-gray-700 mb-1">Nama Klien <span class="text-red-500">*</span></label>
                        <select id="klien" name="klien" class="w-full p-2 border border-gray-300 rounded-lg" required>
                            <option value="">-- Pilih Klien --</option>
                            @foreach ($clients as $client)
                                <option value="{{ $client }}" {{ old('klien') == $client ? 'selected' : '' }}>
                                    {{ $client }}
                                </option>
                            @endforeach
                            <option value="TAMBAH_BARU_KLIEN_#" {{ old('klien') == 'TAMBAH_BARU_KLIEN_#' ? 'selected' : '' }}>-- Tambah Klien Baru --</option>
                        </select>
                        
                        {{-- Input untuk klien baru (tersembunyi) --}}
                        <input type="text" id="nama_klien_baru" name="nama_klien_baru" 
                               class="w-full p-2 border border-gray-300 rounded-lg mt-2 {{ old('klien') == 'TAMBAH_BARU_KLIEN_#' ? '' : 'hidden' }}" 
                               placeholder="Masukkan nama klien baru" value="{{ old('nama_klien_baru') }}">
                    </div>
                    
                    <div>
                        <label for="nilai_kontrak" class="block text-sm font-medium text-gray-700 mb-1">Nilai Kontrak (Rp)</label>
                        <input type="number" name="nilai_kontrak" id="nilai_kontrak" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('nilai_kontrak') }}" required>
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-gray-700 mb-1">Deskripsi Singkat (Opsional)</label>
                        <textarea name="deskripsi" id="deskripsi" rows="4" class="w-full p-2 border border-gray-300 rounded-lg">{{ old('deskripsi') }}</textarea>
                    </div>
                </div>

                {{-- Kolom Kanan --}}
                <div class="space-y-4">
                    <div>
                        <label for="tanggal_mulai" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
                        <input type="date" name="tanggal_mulai" id="tanggal_mulai" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('tanggal_mulai') }}" required>
                    </div>

                    <div>
                        <label for="target_selesai" class="block text-sm font-medium text-gray-700 mb-1">Target Selesai</label>
                        <input type="date" name="target_selesai" id="target_selesai" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('target_selesai') }}" required>
                    </div>
                    
                    <div>
                        <label for="pic" class="block text-sm font-medium text-gray-700 mb-1">Nama PIC (Person in Charge)</label>
                        <input type="text" name="pic" id="pic" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('pic') }}" required>
                    </div>

                    <div>
                        <label for="no_pic" class="block text-sm font-medium text-gray-700 mb-1">Nomor Telepon PIC</label>
                        <input type="text" name="no_pic" id="no_pic" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('no_pic') }}" required>
                    </div>
                </div>
            </div>

            {{-- Tombol Aksi --}}
            <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6">
                <a href="{{ route('proyek.index') }}" class="px-4 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400">Batal</a>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Simpan Proyek</button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const klienSelect = document.getElementById('klien');
        const klienBaruInput = document.getElementById('nama_klien_baru');

        klienSelect.addEventListener('change', function() {
            if (this.value === 'TAMBAH_BARU_KLIEN_#') {
                klienBaruInput.classList.remove('hidden');
                klienBaruInput.required = true;
            } else {
                klienBaruInput.classList.add('hidden');
                klienBaruInput.required = false;
                klienBaruInput.value = ''; // Kosongkan nilainya
            }
        });

        // Pengecekan saat halaman dimuat (jika ada error validasi)
        if (klienSelect.value === 'TAMBAH_BARU_KLIEN_#') {
            klienBaruInput.classList.remove('hidden');
            klienBaruInput.required = true;
        }
    });
</script>
@endpush