@extends('layouts.Project')

@section('content')
<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Buat Task Baru</h1>
        <p class="text-gray-500 mt-1">Isi detail di bawah untuk menugaskan pekerjaan kepada anggota Anda.</p>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-gray-200 max-w-4xl mx-auto">
        @if ($errors->any())
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 text-red-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Oops! Ada beberapa kesalahan:</p>
                <ul class="mt-2 list-disc list-inside text-sm">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('tasks.store') }}" method="POST" class="space-y-6">
            @csrf
            
            <div>
                <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Judul Task <span class="text-red-500">*</span></label>
                <input type="text" name="title" id="title" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('title') }}" placeholder="Contoh: Siapkan laporan PPh 21 untuk Proyek A" required>
            </div>

            <div>
                <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Deskripsi (Opsional)</label>
                <textarea name="description" id="description" rows="4" class="w-full p-2 border border-gray-300 rounded-lg" placeholder="Tuliskan detail, poin-poin, atau instruksi di sini...">{{ old('description') }}</textarea>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="proyek_id" class="block text-sm font-medium text-gray-700 mb-1">Proyek Terkait <span class="text-red-500">*</span></label>
                    <select name="proyek_id" id="proyek_id" class="w-full p-2 border border-gray-300 rounded-lg" required>
                        <option value="">-- Pilih Proyek --</option>
                        {{-- Data $proyeks ini diambil dari controller --}}
                        @foreach($proyeks as $proyek)
                            <option value="{{ $proyek->id_proyek }}" {{ old('proyek_id') == $proyek->id_proyek ? 'selected' : '' }}>
                                {{ $proyek->nama_proyek }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- [DIUBAH] Menggunakan $anggota, bukan $users --}}
                <div>
                    <label for="anggota_id" class="block text-sm font-medium text-gray-700 mb-1">Tugaskan Kepada (Anggota) <span class="text-red-500">*</span></label>
                    <select name="anggota_id" id="anggota_id" class="w-full p-2 border border-gray-300 rounded-lg" required>
                        <option value="">-- Pilih Anggota --</option>
                        {{-- Data $anggota (dari tabel baru) ini diambil dari controller --}}
                        @foreach($anggota as $member)
                            <option value="{{ $member->id }}" {{ old('anggota_id') == $member->id ? 'selected' : '' }}>
                                {{ $member->nama }} {{-- Asumsi kolom 'nama' di tabel anggota --}}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="priority" class="block text-sm font-medium text-gray-700 mb-1">Prioritas</label>
                    <select name="priority" id="priority" class="w-full p-2 border border-gray-300 rounded-lg">
                        <option value="Low" {{ old('priority') == 'Low' ? 'selected' : '' }}>Low</option>
                        <option value="Medium" {{ old('priority', 'Medium') == 'Medium' ? 'selected' : '' }}>Medium</option>
                        <option value="High" {{ old('priority') == 'High' ? 'selected' : '' }}>High</option>
                    </select>
                </div>
                <div>
                    <label for="due_date" class="block text-sm font-medium text-gray-700 mb-1">Jatuh Tempo (Opsional)</label>
                    <input type="date" name="due_date" id="due_date" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('due_date') }}">
                </div>
            </div>
            
            {{-- Tombol Aksi --}}
            <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6">
                <a href="{{ route('tasks.index') }}" class="px-4 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400">Batal</a>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Simpan Task</button>
            </div>
        </form>
    </div>
</div>
@endsection