<?php
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

if (!function_exists('isImage')) {
    function isImage($path) {
        if (!$path) return false;
        $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
        return in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp']);
    }
}
?>




<?php $__env->startSection('header'); ?>
    Detail Klien & Legalitas
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto max-w-7xl"
     x-data="{ 
        openImageModal: false,
        imageModalFiles: [],
        imageModalTitle: ''
     }">
     
    
    <div class="flex justify-between items-center mb-6">
        <div>
            <p class="text-lg text-gray-600">
                Proyek: <span class="font-semibold"><?php echo e($dataKlien->proyek->nama_proyek ?? 'N/A'); ?></span>
            </p>
            <p class="text-lg text-gray-600">
                Klien: <span class="font-semibold"><?php echo e($dataKlien->user->name ?? 'N/A'); ?></span>
            </p>
        </div>
        <a href="<?php echo e(route('klien.edit', $dataKlien->id)); ?>" class="inline-flex items-center bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-lg shadow-md transition-all">
            <svg class="w-5 h-5 mr-2 -ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.5L15.232 5.232z"></path></svg>
            Edit Data Ini
        </a>
    </div>

    
    <div class="bg-white shadow-xl rounded-lg overflow-hidden">
        <div class="grid grid-cols-1 lg:grid-cols-5">
            
            
            <div class="lg:col-span-3 p-6 md:p-8">
                <h3 class="text-xl font-semibold text-gray-900 border-b pb-3 mb-6">Informasi Dasar</h3>
                
                <div class="space-y-6">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Jenis Bangunan</dt>
                        <dd class="mt-1 text-base text-gray-900"><?php echo e($dataKlien->jenis_bangunan); ?></dd>
                    </div>
                    
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Alamat Proyek</dt>
                        <dd class="mt-1 text-base text-gray-900 whitespace-pre-wrap"><?php echo e($dataKlien->alamat); ?></dd>
                    </div>

                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-6">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Nomor PBG</dt>
                            <dd class="mt-1 text-base text-gray-900"><?php echo e($dataKlien->nomor_pbg ?? '-'); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Tanggal Terbit PBG</dt>
                            <dd class="mt-1 text-base text-gray-900"><?php echo e($dataKlien->tanggal_terbit ? \Carbon\Carbon::parse($dataKlien->tanggal_terbit)->format('d M Y') : '-'); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status Arsitek</dt>
                            <dd class="mt-1 text-base text-gray-900"><?php echo e($dataKlien->status_arsitek ?? '-'); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Tanggal OSS</dt>
                            <dd class="mt-1 text-base text-gray-900"><?php echo e($dataKlien->tanggal_oss ? \Carbon\Carbon::parse($dataKlien->tanggal_oss)->format('d M Y') : '-'); ?></dd>
                        </div>
                    </div>

                    
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Analisa</dt>
                        <dd class="mt-1 text-base text-gray-900 whitespace-pre-wrap"><?php echo e($dataKlien->Analisa ?? '-'); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Keterangan</dt>
                        <dd class="mt-1 text-base text-gray-900 whitespace-pre-wrap"><?php echo e($dataKlien->keterangan ?? '-'); ?></dd>
                    </div>
                </div>
            </div>

            
            <div class="lg:col-span-2 bg-gray-50 border-l border-gray-200 p-6 md:p-8">
                <h3 class="text-xl font-semibold text-gray-900 border-b pb-3 mb-6">Dokumen Legalitas</h3>
                
                <div class="mb-6">
                    <dt class="text-sm font-medium text-gray-500">Status Dokumen</dt>
                    <dd class="mt-1">
                        <?php if($dataKlien->status == 'Lengkap'): ?>
                            <span class="px-3 py-1 text-sm font-semibold rounded-full bg-green-100 text-green-800">
                                <?php echo e($dataKlien->status); ?>

                            </span>
                        <?php else: ?>
                            <span class="px-3 py-1 text-sm font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                <?php echo e($dataKlien->status ?? 'Belum Lengkap'); ?>

                            </span>
                        <?php endif; ?>
                    </dd>
                </div>

                
                <ul class="space-y-3">
                    
                    <li class="flex items-center justify-between p-3 bg-white rounded-lg border border-gray-200 shadow-sm">
                        <div class="flex items-center space-x-3 truncate">
                            <svg class="h-5 w-5 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 012-2h2a2 2 0 012 2v1m-4 0h4"></path></svg>
                            <span class="text-sm font-medium text-gray-700 truncate">File KTP</span>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <?php if(isImage($dataKlien->ktp)): ?>
                                <?php
                                    $fileKtp = json_encode([['src' => Storage::url($dataKlien->ktp), 'download' => route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'ktp']), 'deskripsi' => 'KTP - ' . ($dataKlien->user->name ?? 'Klien')]]);
                                ?>
                                <button type="button" @click="openImageModal = true; imageModalFiles = <?php echo e($fileKtp); ?>; imageModalTitle = 'Dokumen KTP'" class="text-sm font-medium text-blue-600 hover:underline">Lihat</button>
                            <?php elseif($dataKlien->ktp): ?>
                                <a href="<?php echo e(route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'ktp'])); ?>" class="text-sm font-medium text-blue-600 hover:underline">Download</a>
                            <?php else: ?>
                                <span class="text-sm text-gray-400">Kosong</span>
                            <?php endif; ?>
                        </div>
                    </li>
                    
                    
                    <li class="flex items-center justify-between p-3 bg-white rounded-lg border border-gray-200 shadow-sm">
                        <div class="flex items-center space-x-3 truncate">
                             <svg class="h-5 w-5 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                            <span class="text-sm font-medium text-gray-700 truncate">File SHM</span>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <?php if(isImage($dataKlien->shm)): ?>
                                <?php
                                    $fileShm = json_encode([['src' => Storage::url($dataKlien->shm), 'download' => route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'shm']), 'deskripsi' => 'SHM - ' . ($dataKlien->proyek->nama_proyek ?? 'Proyek')]]);
                                ?>
                                <button type="button" @click="openImageModal = true; imageModalFiles = <?php echo e($fileShm); ?>; imageModalTitle = 'Dokumen SHM'" class="text-sm font-medium text-blue-600 hover:underline">Lihat</button>
                            <?php elseif($dataKlien->shm): ?>
                                <a href="<?php echo e(route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'shm'])); ?>" class="text-sm font-medium text-blue-600 hover:underline">Download</a>
                            <?php else: ?>
                                <span class="text-sm text-gray-400">Kosong</span>
                            <?php endif; ?>
                        </div>
                    </li>
                    
                    
                    <li class="flex items-center justify-between p-3 bg-white rounded-lg border border-gray-200 shadow-sm">
                        <div class="flex items-center space-x-3 truncate">
                            <svg class="h-5 w-5 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l-1.586-1.586a2 2 0 010-2.828L16 8M4 16V6a2 2 0 012-2h12a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2z"></path></svg>
                            <span class="text-sm font-medium text-gray-700 truncate">File Gambar</span>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <?php if(is_array($dataKlien->gambar) && !empty($dataKlien->gambar)): ?>
                                <?php
                                    $gambarData = []; $nonGambarCount = 0;
                                    foreach($dataKlien->gambar as $item) {
                                        if(isset($item['path']) && isImage($item['path'])) { 
                                            $url = Storage::url($item['path']);
                                            $gambarData[] = ['src' => $url, 'download' => $url, 'deskripsi' => $item['deskripsi'] ?? '...'];
                                        } elseif (isset($item['path'])) { $nonGambarCount++; }
                                    }
                                    $gambarJson = htmlspecialchars(json_encode($gambarData));
                                ?>
                                
                                <?php if(count($gambarData) > 0): ?>
                                    <button type="button" 
                                            @click="openImageModal = true; imageModalFiles = <?php echo $gambarJson; ?>; imageModalTitle = 'Galeri Gambar Arsitek'"
                                            class="text-sm font-medium text-blue-600 hover:underline">
                                        Lihat Galeri (<?php echo e(count($gambarData)); ?>)
                                    </button>
                                <?php endif; ?>
                                <?php if($nonGambarCount > 0): ?>
                                    <span class="text-gray-500 text-xs block">(<?php echo e($nonGambarCount); ?> file non-gambar)</span>
                                <?php endif; ?>
                                <?php if(count($gambarData) == 0 && $nonGambarCount == 0): ?>
                                     <span class="text-sm text-gray-400">Kosong</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-sm text-gray-400">Kosong</span>
                            <?php endif; ?>
                        </div>
                    </li>
                    
                    
                    <li class="flex items-center justify-between p-3 bg-white rounded-lg border border-gray-200 shadow-sm">
                        <div class="flex items-center space-x-3 truncate">
                            <svg class="h-5 w-5 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                            <span class="text-sm font-medium text-gray-700 truncate">File ITR</span>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <?php if(isImage($dataKlien->ITR)): ?>
                                <?php
                                    $fileItr = json_encode([['src' => Storage::url($dataKlien->ITR), 'download' => route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'ITR']), 'deskripsi' => 'ITR - ' . ($dataKlien->proyek->nama_proyek ?? 'Proyek')]]);
                                ?>
                                <button type="button" @click="openImageModal = true; imageModalFiles = <?php echo e($fileItr); ?>; imageModalTitle = 'Dokumen ITR'" class="text-sm font-medium text-blue-600 hover:underline">Lihat</button>
                            <?php elseif($dataKlien->ITR): ?>
                                <a href="<?php echo e(route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'ITR'])); ?>" class="text-sm font-medium text-blue-600 hover:underline">Download</a>
                            <?php else: ?>
                                <span class="text-sm text-gray-400">Kosong</span>
                            <?php endif; ?>
                        </div>
                    </li>
                    
                    
                    <li class="flex items-center justify-between p-3 bg-white rounded-lg border border-gray-200 shadow-sm">
                        <div class="flex items-center space-x-3 truncate">
                            <svg class="h-5 w-5 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 0v-2a2 2 0 00-2-2H9a2 2 0 00-2 2v2m0 0h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                            <span class="text-sm font-medium text-gray-700 truncate">File MEP</span>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                             <?php if(isImage($dataKlien->perhitungan_MEP)): ?>
                                <?php
                                    $fileMep = json_encode([['src' => Storage::url($dataKlien->perhitungan_MEP), 'download' => route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'perhitungan_MEP']), 'deskripsi' => 'Perhitungan MEP - ' . ($dataKlien->proyek->nama_proyek ?? 'Proyek')]]);
                                ?>
                                <button type="button" @click="openImageModal = true; imageModalFiles = <?php echo e($fileMep); ?>; imageModalTitle = 'Dokumen Perhitungan MEP'" class="text-sm font-medium text-blue-600 hover:underline">Lihat</button>
                            <?php elseif($dataKlien->perhitungan_MEP): ?>
                                <a href="<?php echo e(route('klien.downloadFile', ['id' => $dataKlien->id, 'field' => 'perhitungan_MEP'])); ?>" class="text-sm font-medium text-blue-600 hover:underline">Download</a>
                            <?php else: ?>
                                <span class="text-sm text-gray-400">Kosong</span>
                            <?php endif; ?>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    
    <div class="mt-6 text-right">
        <a href="<?php echo e(route('klien.index')); ?>" class="inline-flex items-center text-gray-600 hover:text-blue-700 font-medium group">
            <svg class="w-4 h-4 mr-2 transition-transform duration-200 group-hover:-translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
            Kembali ke Daftar Klien
        </a>
    </div>
    
    
    
    <div x-show="openImageModal" 
         style="display: none;" 
         x-transition:enter="ease-out duration-300" 
         x-transition:enter-start="opacity-0" 
         x-transition:enter-end="opacity-100" 
         x-transition:leave="ease-in duration-200" 
         x-transition:leave-start="opacity-100" 
         x-transition:leave-end="opacity-0" 
         class="fixed inset-0 z-40 flex items-center justify-center bg-gray-900 bg-opacity-80 p-4">
        
        <div @click.outside="openImageModal = false" 
             class="relative bg-white rounded-lg shadow-xl w-full max-w-4xl h-full max-h-[90vh] flex flex-col">
            
            <div class="flex justify-between items-center p-4 border-b">
                <h3 class="text-lg font-medium text-gray-900" x-text="imageModalTitle">
                    Lihat Dokumen
                </h3>
                <button @click="openImageModal = false" class="text-gray-400 hover:text-gray-600">
                     <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                </button>
            </div>
            
            <div class="p-6 flex-1 overflow-y-auto space-y-4">
                <template x-for="(file, index) in imageModalFiles" :key="index">
                    <div class="flex flex-col md:flex-row items-start border rounded-lg overflow-hidden shadow">
                        <div class="w-full md:w-1/2 flex-shrink-0 bg-gray-100 flex items-center justify-center p-2 min-h-[200px]">
                            <img :src="file.src" class="object-contain max-w-full max-h-64 md:max-h-full" alt="Preview Dokumen">
                        </div>
                        <div class="w-full md:w-1/2 p-4 flex flex-col justify-between">
                            <div>
                                <h4 class="font-semibold text-gray-800">Deskripsi:</h4>
                                <p class="text-gray-700 mt-1 whitespace-pre-wrap" x-text="file.deskripsi || 'Tidak ada deskripsi'"></p>
                            </div>
                            <a :href="file.download" 
                               download
                               class="inline-flex items-center justify-center px-4 py-2 mt-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                               <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path></svg>
                               Download
                            </a>
                        </div>
                    </div>
                </template>
                <template x-if="imageModalFiles.length === 0">
                    <p class="text-gray-500 text-center">Tidak ada gambar untuk ditampilkan.</p>
                </template>
            </div>
        </div>
    </div>
    
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.project', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/klien/show.blade.php ENDPATH**/ ?>