

<?php $__env->startSection('content'); ?>

<div class="mb-6">
    <h1 class="text-3xl font-bold text-gray-800">Progress Klien</h1>
    <p class="text-gray-500 text-sm mt-1">
        Pantau kelengkapan dokumen untuk setiap klien dalam tampilan Kanban.
    </p>
</div>


<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    
    <?php $__currentLoopData = $kolomTugas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kolom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
        <div class="bg-gray-100 rounded-xl p-3 h-full border border-gray-200">
            
            
            <div class="flex justify-between items-center mb-4 px-1">
                <?php
                    $statusColors = [
                        'Lengkap' => 'bg-green-100 text-green-800',
                        'Proses' => 'bg-yellow-100 text-yellow-800',
                        'Belum Lengkap' => 'bg-red-100 text-red-800',
                    ];
                    $statusClass = $statusColors[$kolom->nama] ?? 'bg-gray-100 text-gray-800';
                ?>
                <h4 class="text-sm font-semibold text-gray-700 uppercase tracking-wide"><?php echo e($kolom->nama); ?></h4>
                <span class="px-2.5 py-0-5 rounded-full text-xs font-medium <?php echo e($statusClass); ?> whitespace-nowrap">
                    <?php echo e(count($kolom->tasks)); ?> Klien
                </span>
            </div>
            
            
            <div class="space-y-4">
                <?php $__empty_1 = true; $__currentLoopData = $kolom->tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $klien): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4"
                         x-data="checklistCard(<?php echo e($klien->id); ?>, <?php echo json_encode($klien->checklist_status ?? [], 15, 512) ?>)"
                         x-init="calculateProgress()">
                        
                        
                        <h5 class="font-bold text-gray-900 mb-2 truncate" title="<?php echo e($klien->proyek->nama_proyek ?? 'Nama Proyek'); ?>"><?php echo e($klien->proyek->nama_proyek ?? 'Nama Proyek'); ?></h5>
                        <p class="text-sm text-gray-600 mb-4">
                            Klien: <span class="font-medium"><?php echo e($klien->user->name ?? '-'); ?></span>
                        </p>

                        
                        <div class="mb-3">
                            <div class="flex justify-between items-center mb-1">
                                <span class="text-xs font-medium text-gray-500">Progress Checklist</span>
                                <span class="text-xs font-bold text-gray-700" x-text="progress + '%'"></span>
                            </div>
                            <div class="w-full bg-gray-200 rounded-full h-2">
                                <div class="bg-blue-600 h-2 rounded-full transition-all duration-300" 
                                     :style="`width: ${progress}%`"></div>
                            </div>
                        </div>

                        
                        <div class="mb-3">
                            <h6 class="text-xs font-medium text-gray-500 mb-2">Checklist</h6>
                            <div class="space-y-1">
                                <template x-if="subtasks.length === 0">
                                    <p class="text-xs text-gray-400 p-1 italic">Belum ada subtask...</p>
                                </template>
                                
                                <template x-for="task in subtasks" :key="task.id">
                                    <div class="flex items-center group p-1.5 rounded-md hover:bg-gray-50">
                                        
                                        
                                        <input type="checkbox"
                                               :id="`task-${task.id}`"
                                               class="w-4 h-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500"
                                               x-model="task.done"
                                               @change="onCheckChange()">
                                        
                                        <label :for="`task-${task.id}`"
                                               class="ml-2 flex-1 text-sm text-gray-700 cursor-pointer"
                                               :class="{'line-through text-gray-400': task.done}"
                                               x-text="task.text"></label>
                                        
                                        <button @click="deleteSubtask(task.id)" 
                                                class="ml-2 text-gray-400 hover:text-red-500 opacity-0 group-hover:opacity-100 transition-opacity">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                                        </button>
                                    </div>
                                </template>
                            </div>
                        </div>

                        
                        <div class="mt-4 pt-2 border-t border-gray-100">
                            <div class="flex space-x-2">
                                <input type="text"
                                       x-model="newSubtaskText"
                                       @keydown.enter.prevent="addNewSubtask()"
                                       placeholder="Tambah list..."
                                       class="flex-1 block w-full px-3 py-1.5 border border-gray-300 rounded-md shadow-sm text-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                                
                                <button @click="addNewSubtask()"
                                        class="bg-gray-200 hover:bg-gray-300 text-gray-700 text-sm font-medium px-3 rounded-md">
                                    Add
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="p-4 text-center text-sm text-gray-500">
                        Tidak ada data klien pada status ini.
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>

<script>
    function checklistCard(klienId, initialChecklist) {
        return {
            klienId: klienId,
            subtasks: initialChecklist || [],
            newSubtaskText: '',
            progress: 0,
            
            calculateProgress() {
                let total = this.subtasks.length;
                if (total === 0) {
                    this.progress = 0;
                    return;
                }
                let completed = this.subtasks.filter(task => task.done).length;
                this.progress = Math.round((completed / total) * 100);
            },

            onCheckChange() {
                // x-model sudah mengubah datanya.
                // Kita hanya perlu hitung ulang progress dan simpan.
                this.calculateProgress();
                this.saveList();
            },
            
            addNewSubtask() {
                if (this.newSubtaskText.trim() === '') return;
                
                this.subtasks.push({
                    id: Date.now(),
                    text: this.newSubtaskText.trim(),
                    done: false
                });
                
                this.newSubtaskText = '';
                this.calculateProgress();
                this.saveList();
            },
            
            deleteSubtask(taskId) {
                if (!confirm('Anda yakin ingin menghapus subtask ini?')) return;
                
                this.subtasks = this.subtasks.filter(t => t.id !== taskId);
                this.calculateProgress();
                this.saveList();
            },

            saveList() {
                clearTimeout(this.saveTimeout);
                this.saveTimeout = setTimeout(() => {
                    fetch('<?php echo e(route("progress.checklist.save")); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        },
                        body: JSON.stringify({
                            klien_id: this.klienId,
                            checklist: this.subtasks
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (!data.success) {
                            console.error('Gagal menyimpan checklist.');
                        }
                    })
                    .catch(error => console.error('Error:', error));
                }, 500); 
            }
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.project', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/progress/index.blade.php ENDPATH**/ ?>