<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Proyek;

class ProyekController extends Controller
{
    public function index()
    {
        $proyeks = Proyek::latest()->paginate(10);
        return view('proyek.index', compact('proyeks'));
    }

    /**
     * **FITUR BARU:** Method untuk menandai proyek sebagai 'Selesai'.
     */
    public function tandaiSelesai(Proyek $proyek)
    {
        $proyek->status = 'Selesai';
        $proyek->save();

        return redirect()->route('proyek.index')->with('success', 'Proyek berhasil ditandai sebagai selesai.');
    }
}

