@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-2">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">Dashboard Kontraktor</h1>

    {{-- Grid untuk Statistik Utama --}}
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        {{-- Card Proyek Berjalan --}}
        <div class="bg-blue-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-blue-800">Proyek Sedang Berjalan</h2>
            <p class="text-3xl font-bold text-blue-900 mt-2">{{ $proyekBerjalan }}</p>
        </div>
        {{-- Card Proyek Selesai --}}
        <div class="bg-green-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-green-800">Proyek Selesai</h2>
            <p class="text-3xl font-bold text-green-900 mt-2">{{ $proyekSelesai }}</p>
        </div>
        {{-- Card Pengeluaran Bulan Ini --}}
        <div class="bg-yellow-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-yellow-800">Pengeluaran Bulan Ini</h2>
            <p class="text-3xl font-bold text-yellow-900 mt-2">Rp. {{ number_format($pengeluaranBulanIni, 0, ',', '.') }}</p>
        </div>
        {{-- Card Tagihan Jatuh Tempo --}}
        <div class="bg-red-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-red-800">Tagihan Jatuh Tempo</h2>
            <p class="text-3xl font-bold text-red-900 mt-2">{{ $tagihanJatuhTempo }}</p>
        </div>
    </div>

    {{-- Laporan Keuangan & Grafik --}}
    <div class="grid grid-cols-1 lg:grid-cols-5 gap-8 mb-8">
        {{-- Laporan Keuangan --}}
        <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Laporan Keuangan (Keseluruhan)</h3>
            <div class="space-y-4">
                 <div class="flex justify-between items-center bg-green-50 p-3 rounded-md">
                    <span class="font-medium text-green-800">Total Pemasukan</span>
                    <span class="font-bold text-green-800">Rp. {{ number_format($totalPemasukan, 0, ',', '.') }}</span>
                </div>
                <div class="flex justify-between items-center bg-red-50 p-3 rounded-md">
                    <span class="font-medium text-red-800">Total Pengeluaran</span>
                    <span class="font-bold text-red-800">Rp. {{ number_format($totalPengeluaran + $totalUpahTukang, 0, ',', '.') }}</span>
                </div>
                <div class="flex justify-between items-center bg-blue-50 p-3 rounded-md">
                    <span class="font-medium text-blue-800">Profit/Loss</span>
                    <span class="font-bold text-blue-800">Rp. {{ number_format($profitLoss, 0, ',', '.') }}</span>
                </div>
            </div>
        </div>
        
        {{-- Chart Pengeluaran Proyek --}}
        <div class="lg:col-span-3 bg-white p-6 rounded-lg shadow-lg">
             <h3 class="font-bold text-lg mb-4 text-gray-700">Grafik Pengeluaran per Proyek</h3>
             @if($chartLabels->isNotEmpty())
                <canvas id="projectExpenseChart"></canvas>
             @else
                <div class="flex items-center justify-center h-full text-center">
                    <p class="text-gray-500">Belum ada data pengeluaran yang terhubung ke proyek untuk ditampilkan.</p>
                </div>
             @endif
        </div>
    </div>

    {{-- Data Proyek Aktif & Daftar Supplier --}}
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
        <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Data Proyek Aktif</h3>
            <table class="min-w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="text-left py-2 px-3">Nama Proyek</th>
                        <th class="text-left py-2 px-3">Klien</th>
                        <th class="text-left py-2 px-3">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    @forelse($proyekAktif as $proyek)
                        <tr>
                            <td class="py-2 px-3">{{ $proyek->nama_proyek }}</td>
                            <td class="py-2 px-3">{{ $proyek->klien }}</td>
                            <td class="py-2 px-3"><span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-200 text-blue-800">{{ $proyek->status }}</span></td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="py-4 text-center text-gray-500">Tidak ada proyek yang sedang aktif.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Daftar Supplier</h3>
            <ul class="divide-y">
                @forelse($daftarSupplier as $supplier)
                    <li class="py-2">{{ $supplier->nama_supplier }}</li>
                @empty
                    <li class="py-2 text-gray-500">Belum ada data supplier.</li>
                @endforelse
            </ul>
        </div>
    </div>

    {{-- Daftar Tagihan Jatuh Tempo --}}
    <div class="grid grid-cols-1 lg:grid-cols-1 gap-8">
         <div class="bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Daftar Tagihan Jatuh Tempo (30 Hari ke Depan)</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="text-left py-2 px-3">Supplier</th>
                            <th class="text-left py-2 px-3">Proyek</th>
                            <th class="text-left py-2 px-3">Jatuh Tempo</th>
                            <th class="text-left py-2 px-3">Nilai Tagihan</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y">
                        @forelse($daftarTagihanJatuhTempo as $tagihan)
                            <tr>
                                <td class="py-2 px-3">{{ $tagihan->nama_supplier }}</td>
                                <td class="py-2 px-3">{{ $tagihan->proyek->nama_proyek ?? 'Proyek Dihapus' }}</td>
                                <td class="py-2 px-3 text-red-600 font-medium">{{ \Carbon\Carbon::parse($tagihan->jatuh_tempo)->format('d M Y') }}</td>
                                <td class="py-2 px-3">Rp. {{ number_format($tagihan->nilai_tagihan, 0, ',', '.') }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="py-4 text-center text-gray-500">Tidak ada tagihan jatuh tempo.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Bagian Bawah Sidebar (Tombol Logout) -->
<div class="mt-auto p-6">
                 @auth
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="w-full bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded transition-colors duration-200">
                            Logout
                        </button>
                    </form>
                 @endauth
            </div>
        </aside>
@endsection
@push('scripts')
<script>
    const ctx = document.getElementById('projectExpenseChart');
    if (ctx) {
        // Cek jika ada data untuk ditampilkan
        const chartData = {!! json_encode($chartValues) !!};
        if (chartData.length > 0) {
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: {!! json_encode($chartLabels) !!},
                    datasets: [{
                        label: 'Total Pengeluaran',
                        data: chartData,
                        backgroundColor: 'rgba(54, 162, 235, 0.6)',
                        borderColor: 'rgba(54, 162, 235, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: function(value) {
                                    return 'Rp. ' + new Intl.NumberFormat('id-ID').format(value);
                                }
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    }
                }
            });
        }
    }
</script>
@endpush

