@extends('layouts.owner')

@section('content')
<div class="container mx-auto px-4 py-2">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">Laporan Keuangan</h1>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Card Total Pemasukan -->
        <div class="bg-green-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-green-800">Total Pemasukan (dari Kontrak)</h2>
            <p class="text-3xl font-bold text-green-900 mt-2">Rp. {{ number_format($totalPemasukan, 0, ',', '.') }}</p>
        </div>

        <!-- Card Total Pengeluaran -->
        <div class="bg-red-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-red-800">Total Pengeluaran</h2>
            {{-- PERBAIKAN DI SINI: Menggunakan variabel $totalPengeluaran --}}
            <p class="text-3xl font-bold text-red-900 mt-2">Rp. {{ number_format($totalPengeluaran, 0, ',', '.') }}</p>
        </div>

        <!-- Card Profit/Loss -->
        <div class="bg-blue-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-blue-800">Profit / Loss</h2>
            <p class="text-3xl font-bold {{ $profitLoss >= 0 ? 'text-blue-900' : 'text-red-900' }} mt-2">
                Rp. {{ number_format($profitLoss, 0, ',', '.') }}
            </p>
        </div>
    </div>
</div>
@endsection

