<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Owner Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="flex">
        <!-- Main Content -->
        <main class="w-full">
            <!-- Navbar -->
            <nav class="bg-white shadow-md p-4 flex justify-between items-center">
                <h1 class="text-xl font-bold text-gray-800">Owner Dashboard</h1>
                <div class="flex items-center">
                    <span class="mr-4"><?php echo e(Auth::user()->name); ?></span>
                    <!-- Logout Form -->
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                            Logout
                        </button>
                    </form>
                </div>
            </nav>

            <!-- Content Area -->
            <div class="p-8">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/layouts/owner.blade.php ENDPATH**/ ?>