

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-2">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">Dashboard Kontraktor</h1>

    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        
        <div class="bg-blue-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-blue-800">Proyek Sedang Berjalan</h2>
            <p class="text-3xl font-bold text-blue-900 mt-2"><?php echo e($proyekBerjalan); ?></p>
        </div>
        
        <div class="bg-green-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-green-800">Proyek Selesai</h2>
            <p class="text-3xl font-bold text-green-900 mt-2"><?php echo e($proyekSelesai); ?></p>
        </div>
        
        <div class="bg-yellow-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-yellow-800">Pengeluaran Bulan Ini</h2>
            <p class="text-3xl font-bold text-yellow-900 mt-2">Rp. <?php echo e(number_format($pengeluaranBulanIni, 0, ',', '.')); ?></p>
        </div>
        
        <div class="bg-red-100 p-6 rounded-lg shadow-md transition-transform transform hover:scale-105">
            <h2 class="text-lg font-semibold text-red-800">Tagihan Jatuh Tempo</h2>
            <p class="text-3xl font-bold text-red-900 mt-2"><?php echo e($tagihanJatuhTempo); ?></p>
        </div>
    </div>

    
    <div class="grid grid-cols-1 lg:grid-cols-5 gap-8 mb-8">
        
        <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Laporan Keuangan (Keseluruhan)</h3>
            <div class="space-y-4">
                 <div class="flex justify-between items-center bg-green-50 p-3 rounded-md">
                    <span class="font-medium text-green-800">Total Pemasukan</span>
                    <span class="font-bold text-green-800">Rp. <?php echo e(number_format($totalPemasukan, 0, ',', '.')); ?></span>
                </div>
                <div class="flex justify-between items-center bg-red-50 p-3 rounded-md">
                    <span class="font-medium text-red-800">Total Pengeluaran</span>
                    <span class="font-bold text-red-800">Rp. <?php echo e(number_format($totalPengeluaran + $totalUpahTukang, 0, ',', '.')); ?></span>
                </div>
                <div class="flex justify-between items-center bg-blue-50 p-3 rounded-md">
                    <span class="font-medium text-blue-800">Profit/Loss</span>
                    <span class="font-bold text-blue-800">Rp. <?php echo e(number_format($profitLoss, 0, ',', '.')); ?></span>
                </div>
            </div>
        </div>
        
        
        <div class="lg:col-span-3 bg-white p-6 rounded-lg shadow-lg">
             <h3 class="font-bold text-lg mb-4 text-gray-700">Grafik Pengeluaran per Proyek</h3>
             <?php if($chartLabels->isNotEmpty()): ?>
                <canvas id="projectExpenseChart"></canvas>
             <?php else: ?>
                <div class="flex items-center justify-center h-full text-center">
                    <p class="text-gray-500">Belum ada data pengeluaran yang terhubung ke proyek untuk ditampilkan.</p>
                </div>
             <?php endif; ?>
        </div>
    </div>

    
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
        <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Data Proyek Aktif</h3>
            <table class="min-w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="text-left py-2 px-3">Nama Proyek</th>
                        <th class="text-left py-2 px-3">Klien</th>
                        <th class="text-left py-2 px-3">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    <?php $__empty_1 = true; $__currentLoopData = $proyekAktif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proyek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="py-2 px-3"><?php echo e($proyek->nama_proyek); ?></td>
                            <td class="py-2 px-3"><?php echo e($proyek->klien); ?></td>
                            <td class="py-2 px-3"><span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-200 text-blue-800"><?php echo e($proyek->status); ?></span></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="3" class="py-4 text-center text-gray-500">Tidak ada proyek yang sedang aktif.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Daftar Supplier</h3>
            <ul class="divide-y">
                <?php $__empty_1 = true; $__currentLoopData = $daftarSupplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="py-2"><?php echo e($supplier->nama_supplier); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="py-2 text-gray-500">Belum ada data supplier.</li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    
    <div class="grid grid-cols-1 lg:grid-cols-1 gap-8">
         <div class="bg-white p-6 rounded-lg shadow-lg">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Daftar Tagihan Jatuh Tempo (30 Hari ke Depan)</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="text-left py-2 px-3">Supplier</th>
                            <th class="text-left py-2 px-3">Proyek</th>
                            <th class="text-left py-2 px-3">Jatuh Tempo</th>
                            <th class="text-left py-2 px-3">Nilai Tagihan</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y">
                        <?php $__empty_1 = true; $__currentLoopData = $daftarTagihanJatuhTempo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tagihan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="py-2 px-3"><?php echo e($tagihan->nama_supplier); ?></td>
                                <td class="py-2 px-3"><?php echo e($tagihan->proyek->nama_proyek ?? 'Proyek Dihapus'); ?></td>
                                <td class="py-2 px-3 text-red-600 font-medium"><?php echo e(\Carbon\Carbon::parse($tagihan->jatuh_tempo)->format('d M Y')); ?></td>
                                <td class="py-2 px-3">Rp. <?php echo e(number_format($tagihan->nilai_tagihan, 0, ',', '.')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="py-4 text-center text-gray-500">Tidak ada tagihan jatuh tempo.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Bagian Bawah Sidebar (Tombol Logout) -->
<div class="mt-auto p-6">
                 <?php if(auth()->guard()->check()): ?>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded transition-colors duration-200">
                            Logout
                        </button>
                    </form>
                 <?php endif; ?>
            </div>
        </aside>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    const ctx = document.getElementById('projectExpenseChart');
    if (ctx) {
        // Cek jika ada data untuk ditampilkan
        const chartData = <?php echo json_encode($chartValues); ?>;
        if (chartData.length > 0) {
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($chartLabels); ?>,
                    datasets: [{
                        label: 'Total Pengeluaran',
                        data: chartData,
                        backgroundColor: 'rgba(54, 162, 235, 0.6)',
                        borderColor: 'rgba(54, 162, 235, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: function(value) {
                                    return 'Rp. ' + new Intl.NumberFormat('id-ID').format(value);
                                }
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    }
                }
            });
        }
    }
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/dashboard/index.blade.php ENDPATH**/ ?>