<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Kontraktor Dashboard</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <aside class="w-64 bg-gray-800 text-white flex-shrink-0">
            <div class="p-6">
                <h1 class="text-2xl font-bold">Kontraktor</h1>
            </div>
            <nav>
                <a href="<?php echo e(route('dashboard.kontraktor')); ?>" class="block py-3 px-6 hover:bg-gray-700 <?php echo e(request()->routeIs('dashboard') ? 'bg-yellow-500 text-gray-900' : ''); ?>">Overview</a>
                <a href="<?php echo e(route('proyek.index')); ?>" class="block py-3 px-6 hover:bg-gray-700 <?php echo e(request()->routeIs('proyek.index') ? 'bg-yellow-500 text-gray-900' : ''); ?>">Proyek</a>
                <a href="<?php echo e(route('tagihan.index')); ?>" class="block py-3 px-6 hover:bg-gray-700 <?php echo e(request()->routeIs('tagihan.index') ? 'bg-yellow-500 text-gray-900' : ''); ?>">Tagihan</a>
                <a href="<?php echo e(route('pengeluaran.index')); ?>" class="block py-3 px-6 hover:bg-gray-700 <?php echo e(request()->routeIs('pengeluaran.index') ? 'bg-yellow-500 text-gray-900' : ''); ?>">Pengeluaran</a>
                <a href="<?php echo e(route('tukang.index')); ?>" class="block py-3 px-6 hover:bg-gray-700 <?php echo e(request()->routeIs('tukang.index') ? 'bg-yellow-500 text-gray-900' : ''); ?>">Tukang</a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 overflow-y-auto">
            <header class="bg-white shadow p-4 flex justify-end items-center">
                 <div class="flex items-center">
                    <span class="mr-2">Andrian</span>
                    <div class="w-8 h-8 rounded-full bg-yellow-500 text-gray-900 flex items-center justify-center font-bold">A</div>
                </div>
            </header>
            <div class="p-6">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>

    <!-- **PERBAIKAN:** Memindahkan Pustaka Chart.js ke bawah -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/layouts/app.blade.php ENDPATH**/ ?>